import api from '@blocks/api';
import setCaptchaSound from './setCaptchaSound';
import stopCaptchaSound from './stopCaptchaSound';
import {getAudioCaptchaFail, getAudioCaptcha} from './';

export default function changeCaptchaAudio() {
    return function(dispatch, getState) {
        const {
            common: {track_id, uid},
            settings: {language},
            captcha: {trackId}
        } = getState();
        const captchaTrackId = trackId || track_id;

        dispatch(stopCaptchaSound());
        dispatch(getAudioCaptcha());

        api.request('audiocaptcha', {track_id: captchaTrackId, uid, language}, {abortPrevious: true})
            .done((captcha) => dispatch(setCaptchaSound(captcha, true)))
            .fail((error) => dispatch(getAudioCaptchaFail(error)));
    };
}
