import api from '@blocks/api';
import audioCaptchaInit from './audioCaptchaInit';
import setCaptchaSound from './setCaptchaSound';
import {getImageCaptchaSuccess, loadCaptcha, getCaptchaFail} from './';
import {getLanguage, getTrackId} from '@blocks/selectors';
import {TRACK_TYPES} from '@blocks/actions/tracks';

export default function getCaptcha(initAudio = false) {
    return (dispatch, getState) => {
        const state = getState();
        const {
            common: {uid, captchaScaleFactor},
            captcha: {ocr, trackId}
        } = state;
        const language = getLanguage(state);
        const captchaTrack =
            trackId || getTrackId(state, TRACK_TYPES.REGISTER) || getTrackId(state, TRACK_TYPES.COMMON);

        dispatch(loadCaptcha());

        const params = {track_id: captchaTrack, uid, language, ocr};

        if (captchaScaleFactor) {
            params.scale_factor = captchaScaleFactor;
        }

        if (trackId) {
            params.track_id = trackId;
        }

        api.request('textcaptcha', params, {abortPrevious: true})
            .done((captcha) => {
                dispatch(getImageCaptchaSuccess(captcha.key, captcha.image_url));

                if (initAudio) {
                    return dispatch(audioCaptchaInit(captcha));
                }

                return dispatch(setCaptchaSound(captcha));
            })
            .fail(function(error) {
                dispatch(getCaptchaFail(error));
            });
    };
}
