export const CHANGE_CAPTCHA_PLAY_STATUS = 'CHANGE_CAPTCHA_PLAY_STATUS';
export const LOAD_CAPTCHA = 'LOAD_CAPTCHA';
export const GET_CAPTCHA_FAIL = 'GET_CAPTCHA_FAIL';
export const GET_IMAGE_CAPTCHA_SUCCESS = 'GET_IMAGE_CAPTCHA_SUCCESS';
export const GET_AUDIO_CAPTCHA = 'GET_AUDIO_CAPTCHA';
export const GET_AUDIO_CAPTCHA_SUCCESS = 'GET_AUDIO_CAPTCHA_SUCCESS';
export const GET_AUDIO_CAPTCHA_FAIL = 'GET_AUDIO_CAPTCHA_FAIL';
export const CHANGE_CAPTCHA_TYPE = 'CHANGE_CAPTCHA_TYPE';
export const CLEAR_CAPTCHA_PROPS = 'CLEAR_CAPTCHA_PROPS';
export const SET_CAPTCHA_TRACK = 'SET_CAPTCHA_TRACK';

export function getAudioCaptchaFail(error) {
    return {
        type: GET_AUDIO_CAPTCHA_FAIL,
        error
    };
}

export function loadCaptcha() {
    return {
        type: LOAD_CAPTCHA
    };
}

export function getCaptchaFail(error) {
    return {
        type: GET_CAPTCHA_FAIL,
        error
    };
}

export function getAudioCaptcha() {
    return {
        type: GET_AUDIO_CAPTCHA
    };
}

export function changeCaptchaPlayStatus(status) {
    return {
        type: CHANGE_CAPTCHA_PLAY_STATUS,
        playing: status
    };
}

export function getAudioCaptchaSuccess(key, introSound, captchaSound) {
    const actionPayload = {
        type: GET_AUDIO_CAPTCHA_SUCCESS,
        key,
        captchaSound
    };

    if (introSound) {
        actionPayload.introSound = introSound;
    }

    return actionPayload;
}

export function getImageCaptchaSuccess(key, imageUrl) {
    return {
        type: GET_IMAGE_CAPTCHA_SUCCESS,
        key,
        imageUrl
    };
}

export function changeCaptchaType() {
    return {
        type: CHANGE_CAPTCHA_TYPE
    };
}

export function clearCaptchaProps() {
    return {
        type: CLEAR_CAPTCHA_PROPS
    };
}

export function setCaptchaTrack(trackId) {
    return {
        type: SET_CAPTCHA_TRACK,
        trackId
    };
}
