import {changeCaptchaPlayStatus} from './';
import playCaptcha from './playCaptcha';

export default function playCaptchaSound(withIntro) {
    return (dispatch, getState) => {
        const {
            captcha: {playing, introSound}
        } = getState();

        if (playing) {
            return;
        }

        dispatch(changeCaptchaPlayStatus(true));

        if (withIntro) {
            if (introSound && typeof introSound.play === 'function') {
                introSound.play();
            }
        } else {
            dispatch(playCaptcha());
        }
    };
}
