import {getAudioCaptchaFail, getAudioCaptchaSuccess, changeCaptchaPlayStatus} from './';
import playCaptchaSound from './playCaptchaSound';

export default function setCaptchaSound(captcha, autoPlay) {
    return (dispatch) => {
        const Howl = window.Howl;
        const hasVoiceUrl = captcha.voice && captcha.voice.url;

        if (!Howl || !hasVoiceUrl) {
            dispatch(getAudioCaptchaFail());
            return;
        }

        const captchaSound = new Howl({
            src: captcha.voice.url,
            html5: true,
            preload: true,
            format: ['mp3']
        });

        captchaSound.on('load', () => {
            dispatch(getAudioCaptchaSuccess(captcha.key, null, captchaSound));

            if (autoPlay) {
                dispatch(playCaptchaSound());
            }
        });

        captchaSound.on('loaderror', () => dispatch(getAudioCaptchaFail()));
        captchaSound.on('end', () => dispatch(changeCaptchaPlayStatus(false)));

        return;
    };
}
