import {
    CHANGE_CAPTCHA_PLAY_STATUS,
    LOAD_CAPTCHA,
    CHANGE_CAPTCHA_TYPE,
    GET_IMAGE_CAPTCHA_SUCCESS,
    GET_AUDIO_CAPTCHA,
    GET_AUDIO_CAPTCHA_SUCCESS,
    GET_AUDIO_CAPTCHA_FAIL,
    CLEAR_CAPTCHA_PROPS,
    SET_CAPTCHA_TRACK
} from './actions';

export default function(state = {}, action) {
    switch (action.type) {
        case CHANGE_CAPTCHA_PLAY_STATUS:
            return Object.assign({}, state, {
                playing: action.playing
            });
        case CHANGE_CAPTCHA_TYPE:
            return Object.assign({}, state, {
                type: state.type === 'text' ? 'audio' : 'text'
            });
        case LOAD_CAPTCHA: {
            return Object.assign({}, state, {
                loading: true,
                loadingAudio: true
            });
        }
        case GET_AUDIO_CAPTCHA:
            return Object.assign({}, state, {
                loadingAudio: true
            });
        case GET_IMAGE_CAPTCHA_SUCCESS: {
            const newState = {
                loading: false,
                key: action.key,
                imageUrl: action.imageUrl
            };

            return Object.assign({}, state, newState);
        }
        case GET_AUDIO_CAPTCHA_SUCCESS: {
            const newState = {
                loadingAudio: false,
                key: action.key
            };

            if (action.introSound) {
                newState.introSound = action.introSound;
            }

            if (action.captchaSound) {
                newState.captchaSound = action.captchaSound;
            } else {
                newState.captchaSound = null;
            }

            return Object.assign({}, state, newState);
        }
        case GET_AUDIO_CAPTCHA_FAIL:
            return Object.assign({}, state, {
                loadingAudio: false
            });
        case CLEAR_CAPTCHA_PROPS:
            return Object.assign({}, state, {
                loading: false,
                loadingAudio: false,
                playing: false,
                type: 'text',
                key: null,
                imageUrl: null,
                introSound: null,
                captchaSound: null,
                trackId: null
            });
        case SET_CAPTCHA_TRACK:
            return Object.assign({}, state, {
                trackId: action.trackId
            });
        default:
            return state;
    }
}
