import './CaptchaField.styl';
import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Captcha} from '@components/Captcha';
import {Field, FIELDS_NAMES} from '@components/Field';
import {cn} from '@bem-react/classname';

const b = cn('CaptchaField');

export class CaptchaField extends Component {
    fieldRef = React.createRef();

    componentDidMount() {
        if (this.fieldRef.current && this.fieldRef.current.focus) {
            this.fieldRef.current.focus();
        }
    }

    render() {
        const {
            introSound,
            captchaSound,
            imageUrl,
            loading,
            loadingAudio,
            playing,
            type,
            captchaKey,
            captchaAnswer,
            lang,
            fieldError,
            dispatch,
            forcedError,
            fieldView,
            view,
            centered,
            env
        } = this.props;

        return (
            <div className={b('wrapper', {view, centered})}>
                <input type='hidden' name='captcha_key' value={captchaKey || ''} />

                <div className={b('field', {view})}>
                    <Field
                        size='l'
                        label={i18n('_AUTH_.enter_captcha_label')}
                        value={captchaAnswer}
                        name={FIELDS_NAMES.CAPTCHA}
                        type='text'
                        error={fieldError || forcedError}
                        view={fieldView}
                        ref={this.fieldRef}
                    />
                </div>

                <div className={b('image', {view})}>
                    <Captcha
                        isMobile={false}
                        lang={lang}
                        introSound={introSound}
                        captchaSound={captchaSound}
                        imageUrl={imageUrl}
                        loading={loading}
                        loadingAudio={loadingAudio}
                        playing={playing}
                        type={type}
                        dispatch={dispatch}
                        visible={true}
                        env={env}
                    />
                </div>
            </div>
        );
    }
}

CaptchaField.defaultProps = {
    captcha: {
        captchaKey: ''
    },
    centered: false
};

CaptchaField.propTypes = {
    isCaptchaRequired: PropTypes.bool.isRequired,
    isShowCaptcha: PropTypes.bool.isRequired,
    introSound: PropTypes.object,
    captchaSound: PropTypes.object,
    imageUrl: PropTypes.string,
    loading: PropTypes.bool,
    loadingAudio: PropTypes.bool,
    playing: PropTypes.bool,
    type: PropTypes.string,
    captchaKey: PropTypes.string,
    captchaAnswer: PropTypes.string.isRequired,
    lang: PropTypes.string.isRequired,
    fieldError: PropTypes.object,
    forcedError: PropTypes.object,
    dispatch: PropTypes.func.isRequired,
    isNoTabletTouch: PropTypes.bool,
    fieldView: PropTypes.string,
    view: PropTypes.string,
    centered: PropTypes.bool,
    env: PropTypes.shape({
        type: PropTypes.string
    })
};
