import {connect} from 'react-redux';
import {CaptchaField} from './CaptchaField.jsx';
import {getLanguage, getUatraits} from '@blocks/selectors';

function mapStateToProps(state) {
    const {
        settings: {env = {}},
        form,
        captcha: {introSound, captchaSound, imageUrl, loading, loadingAudio, playing, type, key}
    } = state;
    const {errors, values} = form;
    const ua = getUatraits(state);

    return {
        isNoTabletTouch: (ua.isMobile || ua.isTouch) && !ua.isTablet,
        captchaAnswer: values.captcha,
        lang: getLanguage(state),
        fieldError: errors.captcha,
        introSound,
        captchaSound,
        imageUrl,
        loading,
        loadingAudio,
        playing,
        type,
        captchaKey: key,
        env
    };
}

const ConnectedCaptchaField = connect(mapStateToProps, null, null, {forwardRef: true})(CaptchaField);

export {ConnectedCaptchaField as CaptchaField};
