import './CaptchaWithField.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Captcha} from '@components/Captcha';
import {Field, FIELDS_NAMES} from '@components/Field';

const b = cn('CaptchaWithField');

class CaptchaWithField extends React.PureComponent {
    render() {
        const {captchaKey} = this.props;

        return (
            <React.Fragment>
                <Captcha visible={true} {...this.props} />
                <div className={b('field')}>
                    <input type='hidden' name='key' value={captchaKey} />
                    <Field name={FIELDS_NAMES.CAPTCHA} size='l' />
                </div>
            </React.Fragment>
        );
    }
}

CaptchaWithField.propTypes = {
    captchaKey: PropTypes.string
};

export {CaptchaWithField};
