import {connect} from 'react-redux';
import {CaptchaWithField} from './CaptchaWithField.jsx';
import {getLanguage} from '@blocks/selectors';

const maptStateToProps = (state = {}, {isCaptchaRequired}) => {
    const {captcha = {}} = state;
    const {introSound, captchaSound, imageUrl, loading, loadingAudio, playing, type, key} = captcha;

    return {
        introSound,
        captchaSound,
        imageUrl,
        loading,
        loadingAudio,
        playing,
        type,
        captchaKey: key,
        isCaptchaRequired,
        lang: getLanguage(state)
    };
};

const ConnectedCaptchaWithField = connect(maptStateToProps)(CaptchaWithField);

export {ConnectedCaptchaWithField as CaptchaWithField};
