import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

import './Card.styl';
import {CardInfo} from '../CardInfo';

const b = cn('Card');

export class Card extends PureComponent {
    selectCard = () => {
        const {selectCard, card: {id = ''} = {}, onSelect, disableSelect = false} = this.props;

        if (disableSelect) {
            return;
        }

        selectCard(id);

        if (typeof onSelect === 'function' && id) {
            onSelect(id);
        }
    };

    render() {
        const {card: {number = '', system = ''} = {}} = this.props;

        return (
            <div className={b()} onClick={this.selectCard}>
                <div className={b('icon')} />
                <CardInfo system={system} number={number} />
            </div>
        );
    }
}

Card.propTypes = {
    card: PropTypes.shape({
        number: PropTypes.string.isRequired,
        system: PropTypes.string.isRequired,
        id: PropTypes.string.isRequired
    }),
    isPhone: PropTypes.bool,
    isStatic: PropTypes.bool,
    disableSelect: PropTypes.bool,
    setEditMode: PropTypes.func,
    selectCard: PropTypes.func,
    onSelect: PropTypes.func
};
