import {connect} from 'react-redux';
import {push} from 'connected-react-router';
import {Card} from './Card';
import {selectCard} from '@blocks/morda/cards/actions';
import {setEditMode} from '@blocks/common/actions';
import {CARDS_LINK} from '@blocks/morda/cards';

const mapStateToProps = (state = {}) => {
    const {
        settings: {ua = {}}
    } = state;
    const {isMobile, isTouch, isTablet} = ua;
    const isPhone = (isMobile || isTouch) && !isTablet;

    return {
        isPhone
    };
};

const mapDispatchToProps = {
    selectCard,
    setEditMode,
    openCardsLink: push(CARDS_LINK)
};

const ConnectedCard = connect(mapStateToProps, mapDispatchToProps)(Card);

export {ConnectedCard as Card};
