import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

import './CardInfo.styl';

const b = cn('CardInfo');

export const CardInfo = ({system, number}) => {
    const hasDots = number.length === 14;

    return (
        <div className={b()}>
            <span className={b('system')}>{system.toLowerCase()}</span>
            <span className={b('number', {hasDots})}>{hasDots ? number.slice(-4) : number}</span>
        </div>
    );
};

CardInfo.propTypes = {
    number: PropTypes.string.isRequired,
    system: PropTypes.string.isRequired
};
