import {connect} from 'react-redux';
import {CardsList} from './CardsList';
import {selectCard} from '@blocks/morda/cards/actions';
import {getCardsInfo, unbindCard, createBinding} from '@blocks/morda/cards';
import {setEditMode} from '@blocks/common/actions';

const mapStateToProps = (state) => {
    const {common = {}, retpath, billing, settings} = state;

    return {
        billing,
        settings,
        retpath: retpath || common.retpath
    };
};

const mapDispatchToProps = {
    selectCard,
    getCardsInfo,
    unbindCard,
    setEditMode,
    createBinding
};

const ConnectedCardsList = connect(mapStateToProps, mapDispatchToProps)(CardsList);

export {ConnectedCardsList as CardsList};
