import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';

class ChatWidget extends PureComponent {
    chatWidget = null;

    componentDidMount = () => {
        const {guid, theme} = this.props;

        window.yandexChatWidgetCallback = () => {
            try {
                this.chatWidget = new window.Ya.ChatWidget({
                    guid,
                    theme
                });
            } catch (e) {
                this.showChat = () => {};
            }
        };

        const node = document.getElementsByTagName('script')[0],
            script = document.createElement('script');

        this.scriptTag = script;
        script.async = true;
        script.crossorigin = 'anonymous';
        script.src = 'https://chat.s3.yandex.net/widget_ya.js';

        node.parentNode.insertBefore(script, node);
    };

    showChat = (e) => {
        e.preventDefault();

        if (this.chatWidget) {
            this.chatWidget.showChat();
        } else {
            setTimeout(() => {
                this.showChat(e);
            }, 50);
        }
    };

    componentWillUnmount = () => {
        delete window.yandexChatWidgetCallback;
        this.scriptTag.parentNode.removeChild(this.scriptTag);
    };

    render = () => {
        const {children} = this.props;

        if (!children) {
            return null;
        }

        return <>{children({onClick: this.showChat})}</>;
    };
}

ChatWidget.propTypes = {
    guid: PropTypes.string.isRequired,
    theme: PropTypes.string.isRequired,
    children: PropTypes.func
};

export {ChatWidget};
