import {connect} from 'react-redux';
import {CodeField} from './CodeField.jsx';
import {updateErrors, updateValues} from '@blocks/actions/form';
import {setChallengeError} from '@blocks/authv2/actions/challenge';
import {setErrors} from '@blocks/actions/phoneConfirm';

const mapStateToProps = (state = {}, ownProps = {}) => {
    const {
        form: {values = {}, errors = {}} = {},
        phoneConfirm: {callingNumberTemplate} = {},
        challenge: {callFrom, challengeType} = {}
    } = state;
    const {phoneCode = {}} = errors;

    return {
        value: values.phoneCode,
        hasError: Boolean(errors.phoneCode.code || ownProps.error),
        callingNumberTemplate: callingNumberTemplate || callFrom,
        isChallegeProcess: Boolean(challengeType),
        error: phoneCode || ownProps.error
    };
};

const mapDispatchToProps = {
    updateErrors,
    updateValues,
    setChallengeError,
    setPhoneConfirmErrors: setErrors
};

const ConnectedCodeField = connect(mapStateToProps, mapDispatchToProps)(CodeField);

export {ConnectedCodeField as CodeField};
