import './CustomsBackground.styl';
import React from 'react';
import PropTypes from 'prop-types';

export const CustomsBackground = ({bgNumber, bgColor, bgNoDarken}) => {
    const darkenClassName = bgNoDarken ? ' passp-bg_no-darken' : '';

    if (bgColor) {
        return <div className={`passp-bg${darkenClassName}`} style={{backgroundColor: bgColor}} />;
    }
    if (bgNumber) {
        return <div className={`passp-bg passp-bg_${bgNumber}${darkenClassName}`} />;
    }

    return null;
};

CustomsBackground.propTypes = {
    bgNoDarken: PropTypes.bool,
    bgNumber: PropTypes.number,
    bgColor: PropTypes.string
};
