import './Description.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

const b = cn('Description');

export const Description = ({children, dataT, theme, position, size}) => (
    <div
        data-t={dataT ? `description:${dataT}` : 'description'}
        className={b({theme, size, position: position || (IS_AUTH_PAGE && 'center')})}
    >
        {children}
    </div>
);

Description.propTypes = {
    children: PropTypes.node.isRequired,
    dataT: PropTypes.string,
    theme: PropTypes.oneOf(['grey']),
    size: PropTypes.oneOf(['s']),
    position: PropTypes.oneOf(['center', 'left'])
};
