import {connect} from 'react-redux';
import {updateErrors, updateValues, setPasswordWeight} from '@blocks/actions/form';
import {Field} from './Field.jsx';
import {validate} from './validations';
import {hasExp} from '@blocks/selectors';

const FIELDS_LABELS = {
    firstname: i18n('_AUTH_.field_firstname'),
    lastname: i18n('_AUTH_.field_lastname'),
    phone: i18n('_AUTH_.field_label_reg-mobile'),
    phoneCode: i18n('_AUTH_.device.field.label'),
    login: i18n('_AUTH_.field_login'),
    password: i18n('_AUTH_.field_password'),
    password_confirm: i18n('_AUTH_.field_label_repeat-passwd2'),
    eula_accepted: i18n('_AUTH_.money.acceptance.common')
};

const FIELDS_TYPES = {
    default: 'text',
    eula_accepted: 'checkbox',
    phone: 'tel'
};

export const FIELDS_NAMES = {
    FIRSTNAME: 'firstname',
    LASTNAME: 'lastname',
    PHONE: 'phone',
    PHONE_CODE: 'phoneCode',
    LOGIN: 'login',
    PASSWORD: 'password',
    PASSWORD_CONFIRM: 'password_confirm',
    EULA_ACCEPTED: 'eula_accepted',
    EMAIL: 'email',
    EMAIL_CODE: 'email_code',
    CAPTCHA: 'captcha'
};

const ALWAYS_LEFT_ALIGNED_FIELDS = ['login', 'phone', 'email', 'phoneNumber', 'captcha_answer'];

function getLabel(state = {}, props) {
    const {label, name} = props;
    const {am = {}} = state;

    if (am.isAm && am.mode === 'phonish' && name === FIELDS_NAMES.PHONE) {
        return i18n('_AUTH_.field_phone_number');
    }

    return label || FIELDS_LABELS[name];
}

const mapStateToProps = (state = {}, props) => {
    const {value, name, type, error} = props;
    const {form = {}, am = {}, settings = {}} = state;
    const {values = {}, errors = {}} = form;
    const {dir} = settings;

    return {
        isValueForced: props.hasOwnProperty('value'),
        isErrorForced: props.hasOwnProperty('error'),
        value: props.hasOwnProperty('value') ? value || '' : values[name] || '',
        error: props.hasOwnProperty('error') ? error : errors[name],
        label: getLabel(state, props),
        type: type || FIELDS_TYPES[name],
        isAm: am.isAm,
        dir: ALWAYS_LEFT_ALIGNED_FIELDS.includes(name) ? 'ltr' : dir,
        hasRoundViewExp: hasExp(state, 'rounded-input-exp')
    };
};

const mapDispatchToProps = {
    updateValues,
    updateErrors,
    validate,
    setPasswordWeight
};

const ConnectedField = connect(mapStateToProps, mapDispatchToProps, null, {forwardRef: true})(Field);

export {ConnectedField as Field};
