/* eslint-disable max-len */
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

const b = cn('IdLogoShortIcon');

export const IdLogoShortIcon = ({className}) => (
    <svg
        className={b('', [className])}
        width='144'
        height='144'
        viewBox='0 0 144 144'
        fill='none'
        xmlns='http://www.w3.org/2000/svg'
    >
        <path
            fillRule='evenodd'
            clipRule='evenodd'
            d='M144 72C144 111.765 111.765 144 72 144C32.2355 144 0 111.765 0 72C0 32.2355 32.2355 0 72 0C66.7168 0 61.4496 0.581499 56.2937 1.73399L59.5909 16.4849C34.1488 22.1471 15.1276 44.8521 15.1276 71.9998C15.1276 103.41 40.5904 128.873 72.0004 128.873C103.41 128.873 128.873 103.41 128.873 72H144ZM72 0C111.765 0 144 32.2355 144 72C144 66.7168 143.419 61.4496 142.266 56.2937L127.515 59.5908C121.853 34.1485 99.1482 15.1271 72.0004 15.1271H72V0ZM71.9999 114.567C89.5187 114.567 104.566 103.984 111.097 88.8624L97.2315 82.8175C93.0333 92.5967 83.3163 99.4458 71.9996 99.4458C60.802 99.4458 51.1706 92.7401 46.9021 83.1253L33.0375 89.17C39.6386 104.127 54.6001 114.567 71.9999 114.567Z'
            fill='black'
        />
    </svg>
);

IdLogoShortIcon.propTypes = {
    className: PropTypes.string
};
