import React from 'react';
import PropTypes from 'prop-types';
import {getStaticPath} from 'pcomponents';

import he from 'he';

const PAGES_WITHOUT_USER = ['react.registration', 'react.authv2', 'react.family-lazy'];

const isUserAvailable = (page) => !PAGES_WITHOUT_USER.includes(page);

class Body extends React.Component {
    shouldComponentUpdate() {
        return false;
    }

    render() {
        const {serializedStore, children, nonce} = this.props;

        return (
            <React.Fragment>
                <div id='root' className='layout'>
                    {children}
                </div>
                {this.getReact()}
                {this.getJS()}
                {this.getIntranetFrame()}
                {this.getBeatle()}
                {this.getYsa()}
                {this.getUserScript()}
                <script
                    type='text/javascript'
                    nonce={nonce}
                    id='storeScript'
                    dangerouslySetInnerHTML={{__html: `window.__REDUX_STORE__ = ${serializedStore}`}}
                />
            </React.Fragment>
        );
    }

    getReact = () => {
        const {reactStaticVersion, withLoadable} = this.props;
        const props = {
            crossOrigin: 'anonymous',
            src: reactStaticVersion
        };

        if (!withLoadable) {
            props.defer = 'defer';
        }

        return <script {...props} />;
    };

    getJS = () => {
        const {settings = {}, page, withLoadable, language} = this.props;
        const {staticPath} = settings;

        if (withLoadable) {
            return null;
        }

        return (
            <React.Fragment>
                <script crossOrigin='anonymous' defer='defer' src={`${staticPath}/js/${page}.vendors.${language}.js`} />
                <script crossOrigin='anonymous' defer='defer' src={`${staticPath}/js/${page}.lego.${language}.js`} />
                <script crossOrigin='anonymous' defer='defer' src={`${staticPath}/js/${page}.react.${language}.js`} />
            </React.Fragment>
        );
    };

    getIntranetFrame = () => {
        const {settings = {}, isYandex} = this.props;
        const {intranet} = settings;

        if (isYandex && intranet) {
            return <iframe style={{display: 'none'}} src='https://yandex-team.ru/' />;
        }

        return null;
    };

    getBeatle = () => {
        const {isYandexoid, isYandex, hideBeatle, beatleUrl} = this.props;

        if ((isYandexoid || isYandex) && beatleUrl && !hideBeatle) {
            return (
                <script
                    src={beatleUrl}
                    id='yndxbug'
                    position='right'
                    container-id='body'
                    modules='forms'
                    form='10016395'
                    custom-theme='compact-long-text-input'
                    screenshot='true'
                    data-domain='yandex'
                    data-data=''
                    data-text=''
                    data-info=''
                    async=''
                />
            );
        }

        return null;
    };

    getYsa = () => {
        const {isYsaAvailable, ysaId, settings = {}} = this.props;
        const {ysaPath} = settings;

        if (!isYsaAvailable || !ysaId) {
            return null;
        }

        return <img className='g-hidden' src={`${ysaPath}/static/1/${ysaId}/d.png?ex=yes`} />;
    };

    getUserScript = () => {
        // Ошметки @components/User
        // Скрипт временно нужен для работы выпадашки пользователя
        // @see https://st.yandex-team.ru/PASSP-29704
        const {page} = this.props;

        if (!isUserAvailable(page)) {
            return;
        }

        const staticPropsUser = {
            key: 'base', // Вариант сборки блока, по умолчанию base
            platform: 'desktop',
            block: 'user2',
            service: 'base'
        };

        return (
            <React.Fragment>
                <script type='text/javascript' src={getStaticPath(staticPropsUser)} />
            </React.Fragment>
        );
    };
}

Body.getBodyAttributes = (props) => {
    const {metricsCounterId, version, metricsUserType, isYaPhoneLite, origin, themeInfo = {}} = props;
    const cssThemeClass =
        themeInfo.cssBodyClass || 'Theme_root_default Theme_color_yandex-default Theme_root_passport Theme_auth_domik';
    const className = isYaPhoneLite ? `is-lite ${cssThemeClass}` : cssThemeClass;

    // eslint-disable-next-line max-len
    return `class="${className}" data-metrics-id="${metricsCounterId}" data-user-type="${metricsUserType}" data-version="${version}" data-origin="${
        origin && typeof origin === 'string' ? he.escape(origin) : null
    }" data-extended-logging="true"`;
};

Body.getOpenBodyTag = (props) => `<body ${Body.getBodyAttributes(props)}>`;

Body.propTypes = {
    settings: PropTypes.shape({
        staticPath: PropTypes.string.isRequired,
        tld: PropTypes.string.isRequired
    }),
    serializedStore: PropTypes.string.isRequired,
    children: PropTypes.node.isRequired,
    page: PropTypes.string.isRequired,
    language: PropTypes.string.isRequired,
    nonce: PropTypes.string.isRequired,
    metricsCounterId: PropTypes.string.isRequired,
    version: PropTypes.string.isRequired,
    reactStaticVersion: PropTypes.string.isRequired,
    isYandexoid: PropTypes.bool,
    isYandex: PropTypes.bool,
    hideBeatle: PropTypes.bool,
    beatleUrl: PropTypes.string,
    isYsaAvailable: PropTypes.bool,
    withLoadable: PropTypes.bool,
    ysaId: PropTypes.string
};

export {Body};
