import '@plibs/rum-counter';
import React from 'react';
import {Provider} from 'react-redux';
import {hydrate} from 'react-dom';
import {RUM_MARKS, sendRumHeroElement, sendRumTimeMark} from '@plibs/rum-counter/utils';
import Logger from '@old-blocks/logger/Logger';
import api from '@blocks/api';
import passport from '@plibs/pclientjs';
import metrics from '@blocks/metrics';
import monitoring from '@blocks/monitoring';
import magic from '@blocks/authv2/magic';
import magicForMail from '@blocks/authv2/checkAuthWithMailStatus';
import {AmErrorBoundary} from '@blocks/authv2/components/AmErrorBoundary';
import oneDomik from '@blocks/one_domik';
import checkPulse from '@blocks/auth/checkPulse';
import {
    setPopupSize,
    onReady,
    getPhoneRegionCode,
    requestSavedExperiments,
    amGetCutsomEulaStrings,
    sendOpenMetrics
} from '@blocks/authv2/actions/nativeMobileApi';
import {replace, ConnectedRouter} from 'connected-react-router';

export const renderClient = ({
    App,
    configureStore,
    metricsData = ['показ страницы'],
    withProvider = true,
    withMagic = false,
    withRouter = false,
    withCheckHuman = false,
    history,
    replaceHistory,
    replaceHistorySearch = location.search,
    broker,
    isOneDomik = false
}) => {
    sendRumTimeMark(RUM_MARKS.BEFORE_JS_FRAMEWORK_INIT);

    const storeScript = document.querySelector('#storeScript');
    const reduxStore = window.__REDUX_STORE__;

    if (replaceHistory) {
        history.replace(`${replaceHistory}${replaceHistorySearch}${location.hash}`);
    }

    const store = withProvider ? configureStore(reduxStore, history) : reduxStore;

    if (replaceHistory) {
        store.dispatch(replace(`${replaceHistory}${replaceHistorySearch}${location.hash}`));
    }

    const {settings = {}, common = {}, am = {}} = reduxStore;
    const {language} = settings;
    const {track_id, dev, csrf} = common;

    delete window.__REDUX_STORE__;
    storeScript.parentNode.removeChild(storeScript);

    if (withProvider) {
        api.init(store);
        passport.init({trackId: track_id, csrf});

        if (withMagic) {
            magic.init(store);
            magicForMail.init(store);
        }

        metrics.init(store);
        monitoring.init(store);

        if (broker) {
            broker.init(store);
        }

        if (isOneDomik) {
            oneDomik.init(store);
            checkPulse.init(store);
        }
    }

    if (withCheckHuman) {
        passport.api.request('checkjsload', {track_id, language});
    }

    if (am.isAm) {
        if (am.isAmPopup) {
            store.dispatch(setPopupSize(am.popupOptions));
        }
        store.dispatch(onReady());
        store.dispatch(getPhoneRegionCode());
        store.dispatch(requestSavedExperiments());
        store.dispatch(amGetCutsomEulaStrings());
        store.dispatch(sendOpenMetrics());
    }

    let Component = withProvider ? (
        <Provider store={store}>
            {withRouter ? (
                <ConnectedRouter history={history}>
                    <App />
                </ConnectedRouter>
            ) : (
                <App />
            )}
        </Provider>
    ) : (
        <App {...store} />
    );

    if (am.isAm) {
        Component = <AmErrorBoundary finishErrorUrl={am.finishErrorUrl}>{Component}</AmErrorBoundary>;
    }

    hydrate(Component, document.getElementById('root'));

    sendRumTimeMark(RUM_MARKS.REACT_INITED);
    sendRumTimeMark(RUM_MARKS.JS_FRAMEWORK_INITED);
    sendRumHeroElement();

    if (withCheckHuman && !dev) {
        Logger.init({
            trackId: track_id
        });
    }

    if (withProvider) {
        metrics.send(metricsData);

        window.onload = () => {
            setTimeout(() => {
                monitoring.send({
                    event: 'load'
                });
            }, 0);
        };
    }
};
