import React from 'react';
import PropTypes from 'prop-types';
import {Field} from '@components/Field';
import {FIELDS_NAMES} from '@components/Field/names';

class Login extends React.PureComponent {
    static defaultProps = {
        type: 'text',
        name: FIELDS_NAMES.LOGIN,
        label: i18n('_AUTH_.field_login')
    };

    ref = React.createRef();

    componentDidMount() {
        this.ref.current.focus();
    }

    render() {
        const {type, name, label, hideLabel, shouldValidate, view, size} = this.props;

        return (
            <Field
                size={size}
                view={view}
                ref={this.ref}
                type={type}
                label={label}
                name={name}
                hideLabel={hideLabel}
                shouldValidate={shouldValidate}
            />
        );
    }
}

Login.propTypes = {
    size: PropTypes.string,
    view: PropTypes.string,
    type: PropTypes.string.isRequired,
    name: PropTypes.string.isRequired,
    label: PropTypes.string.isRequired,
    hideLabel: PropTypes.bool,
    shouldValidate: PropTypes.bool
};

export {Login};
