/* eslint-disable max-len */
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

const b = cn('IdIcon');

export const IdIcon = ({className}) => (
    <svg
        width='26'
        height='26'
        viewBox='0 0 26 26'
        fill='none'
        xmlns='http://www.w3.org/2000/svg'
        className={b('', [className])}
    >
        <path
            fillRule='evenodd'
            clipRule='evenodd'
            d='M26 13C26 20.1797 20.1797 26 13 26C5.8203 26 0 20.1797 0 13C0 5.8203 5.8203 0 13 0C12.0461 0 11.0951 0.104993 10.1641 0.313082L10.7595 2.97645C6.16575 3.99878 2.73137 8.0983 2.73137 13C2.73137 18.6712 7.32881 23.2687 13.0001 23.2687C18.6713 23.2687 23.2687 18.6712 23.2687 13H26ZM13 0C20.1797 0 26 5.8203 26 13C26 12.0461 25.895 11.0951 25.6869 10.1641L23.0236 10.7595C22.0013 6.16571 17.9018 2.73129 13.0001 2.73129H13V0ZM12.9999 20.6856C16.163 20.6856 18.8798 18.7748 20.059 16.0446L17.5556 14.9532C16.7976 16.7188 15.0431 17.9554 12.9999 17.9554C10.9781 17.9554 9.23913 16.7447 8.46842 15.0087L5.96509 16.1001C7.15697 18.8007 9.85832 20.6856 12.9999 20.6856Z'
            fill='black'
        />
    </svg>
);

IdIcon.propTypes = {
    className: PropTypes.string
};
