/* eslint-disable max-len */
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

const b = cn('IdNameIcon');

export const IdNameIcon = ({className}) => (
    <svg
        width='24'
        height='20'
        viewBox='0 0 24 20'
        fill='none'
        xmlns='http://www.w3.org/2000/svg'
        className={b('', [className])}
    >
        <path
            fillRule='evenodd'
            clipRule='evenodd'
            d='M11.0611 19.9876V20H7.20852V0H13.157C14.7199 0 16.1616 0.17252 17.47 0.517559C18.7784 0.862598 19.9172 1.41713 20.8985 2.18114C21.8678 2.94516 22.631 3.96795 23.1762 5.22488C23.7214 6.49413 24 8.04681 24 9.88291C24 12.0641 23.5154 13.9125 22.5583 15.4035C21.6012 16.8946 20.2807 18.0406 18.6088 18.817C16.9369 19.5933 15.047 19.9876 12.939 19.9876H11.0611ZM11.0611 17.0548V2.93283H12.8178C14.2231 2.93283 15.4831 3.14232 16.5735 3.5613C17.6638 3.98028 18.524 4.70732 19.1419 5.7178C19.7597 6.74059 20.0747 8.10843 20.0747 9.83362C20.0747 11.4356 19.7597 12.7665 19.1297 13.8385C18.4998 14.9106 17.6154 15.7116 16.4887 16.2538C15.362 16.796 14.0535 17.0548 12.5634 17.0548H11.0611Z'
            fill='black'
        />
        <path d='M3.81624 20V3.7456e-05H0V20H3.81624Z' fill='black' />
    </svg>
);

IdNameIcon.propTypes = {
    className: PropTypes.string
};
