import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {DownArrowIcon} from '@blocks/Components/DownArrowIcon';
import {YaIcon} from './YaIcon';
import {IdIcon} from './IdIcon';
import {IdNameIcon} from './IdNameIcon';

import './LoginLogoId.styl';

const b = cn('LoginLogoId');

LoginLogoId.views = {
    LOGO: 'logo',
    ACCOUNT_BUTTON: 'accountButton',
    STATIC_ACCOUNT: 'staticAccount'
};

LoginLogoId.propTypes = {
    addUserUrl: PropTypes.string,
    avatarImageUrl: PropTypes.string.isRequired,
    editUrl: PropTypes.string,
    hasUnitedAccounts: PropTypes.bool,
    login: PropTypes.string,
    onClick: PropTypes.func,
    className: PropTypes.string,
    view: PropTypes.string
};

export function LoginLogoId(props) {
    const {addUserUrl, avatarImageUrl, editUrl, login, hasUnitedAccounts, onClick, className, view} = props;

    return (
        <button
            className={b('', {clickable: view === LoginLogoId.views.ACCOUNT_BUTTON}, [className])}
            onClick={(event) => {
                event.preventDefault();
                view === LoginLogoId.views.ACCOUNT_BUTTON && onClick({hasUnitedAccounts, addUserUrl, editUrl});
            }}
        >
            {view === LoginLogoId.views.LOGO && (
                <div className={b('logo')}>
                    <YaIcon />
                    <IdIcon />
                    <IdNameIcon />
                </div>
            )}
            {view === LoginLogoId.views.ACCOUNT_BUTTON && (
                <div className={b('account')}>
                    <div className={b('avatar')} style={{backgroundImage: avatarImageUrl}} />
                    <div className={b('login')}>{login}</div>
                    <div className={b('iconWrapper')}>
                        <DownArrowIcon className={b('icon')} />
                    </div>
                </div>
            )}
            {view === LoginLogoId.views.STATIC_ACCOUNT && (
                <div className={b('account')}>
                    <div className={b('avatar')} style={{backgroundImage: avatarImageUrl}} />
                    <span className={b('login')}>{login}</span>
                </div>
            )}
        </button>
    );
}
