/* eslint-disable max-len */
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

const b = cn('YaIcon');

export const YaIcon = ({className}) => (
    <svg
        width='26'
        height='26'
        viewBox='0 0 26 26'
        fill='none'
        xmlns='http://www.w3.org/2000/svg'
        className={b('', [className])}
    >
        <path
            d='M0 13C0 5.8203 5.8203 0 13 0C20.1797 0 26 5.8203 26 13C26 20.1797 20.1797 26 13 26C5.8203 26 0 20.1797 0 13Z'
            fill='#FC3F1D'
        />
        <path
            d='M14.8321 20.8131H17.548V5.21313H13.5975C9.6246 5.21313 7.53712 7.25573 7.53712 10.2635C7.53712 12.6652 8.68186 14.0793 10.7245 15.5383L7.17798 20.8131H10.1184L14.0689 14.9098L12.6997 13.9895C11.0387 12.8672 10.2306 11.9918 10.2306 10.1064C10.2306 8.44537 11.3978 7.32306 13.62 7.32306H14.8321V20.8131Z'
            fill='white'
        />
    </svg>
);

YaIcon.propTypes = {
    className: PropTypes.string
};
