import {isKeyEnabled2FASelector} from '@blocks/selectors';
import {LoginLogoId} from './LoginLogoId';

export function mapStateToProps(state) {
    const {
        common: {editUrl, addUserUrl},
        settings: {avatar: avatarSettings},
        auth: {processedAccount, defaultAccount, unitedAccounts = {}}
    } = state;
    const account = processedAccount || defaultAccount;
    const {avatarId, login} = account || {};
    const {host, pathname} = avatarSettings;

    const avatarPathname = pathname
        .replace('%uid%', avatarId)
        .replace('%size%', '200')
        .replace('%login%', login);

    let view = login ? LoginLogoId.views.ACCOUNT_BUTTON : LoginLogoId.views.LOGO;

    const isKeyEnabled2FA = isKeyEnabled2FASelector(state);

    if (isKeyEnabled2FA) {
        view = login ? LoginLogoId.views.STATIC_ACCOUNT : LoginLogoId.views.LOGO;
    }

    return {
        avatarImageUrl: `url("https://${host}${avatarPathname}")`,
        login,
        view,
        addUserUrl,
        editUrl,
        hasUnitedAccounts: Object.keys(unitedAccounts).length > 0
    };
}
