import './LoginSuggest.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {classNames} from '@blocks/utils';

const b = classNames('LoginSuggest');

class LoginSuggest extends React.PureComponent {
    state = {
        login: ''
    };

    componentDidMount() {
        const {logins = {}} = this.props;
        const {loginsList = []} = logins;

        if (loginsList.length) {
            return;
        }

        this._getLogins();
    }

    componentDidUpdate(prevProps) {
        const {login} = this.state;
        const {deps: prevDeps} = prevProps;
        const {deps} = this.props;

        if (
            deps.firstname !== prevDeps.firstname ||
            deps.lastname !== prevDeps.lastname ||
            (deps.login !== prevDeps.login && deps.login && deps.login !== login)
        ) {
            this._getLogins();
        }
    }

    _getLogins = () => {
        const {getLogins} = this.props;

        getLogins();
    };

    _updateLogin = (login) => {
        const {updateValues, updateErrors, onLoginClick} = this.props;

        this.setState({login});
        updateErrors({field: 'login', error: {}});
        updateValues({field: 'login', value: login});

        if (typeof onLoginClick === 'function') {
            onLoginClick();
        }
    };

    _renderLoginItem = (login, index) => (
        <button
            type='button'
            onClick={() => this._updateLogin(login)}
            className={b('item')}
            key={`suggest-${login}`}
            data-t={`logins-suggest-item-${index}`}
            aria-label={i18n('_AUTH_.registration.btn.login-suggest.login.aria-label').replace('%', login)}
        >
            {login}
        </button>
    );

    _maybeRenderLoginsList = () => {
        const {login} = this.state;
        const {logins = {}, deps = {}} = this.props;
        const {loginsList = []} = logins;

        if (!loginsList.length || (deps.login && login === deps.login)) {
            return null;
        }

        return (
            <div className={b('list')} data-t='logins-suggest'>
                {loginsList.map((item, index) => this._renderLoginItem(item, index))}
            </div>
        );
    };

    render() {
        return this._maybeRenderLoginsList();
    }
}

LoginSuggest.propTypes = {
    deps: PropTypes.shape({
        firstname: PropTypes.string,
        lastname: PropTypes.string,
        login: PropTypes.string
    }),
    logins: PropTypes.shape({
        loginsList: PropTypes.arrayOf(PropTypes.string),
        isValidating: PropTypes.bool,
        isFetching: PropTypes.bool
    }),
    getLogins: PropTypes.func.isRequired,
    updateValues: PropTypes.func.isRequired,
    updateErrors: PropTypes.func.isRequired,
    onLoginClick: PropTypes.func
};

export {LoginSuggest};
