import api from '@blocks/api';
import {updateSuggestedLogins} from '@blocks/registration/actions';
import {updateValues} from '@blocks/actions/form';

export const getSuggestedLogins = (dispatch, state = {}, useFirstLogin = false) => {
    const {form = {}, tracks = {}, logins = {}} = state;
    const {loginsList = []} = logins;
    const {values = {}} = form;
    const {registerTrackId: trackId} = tracks;
    const isLoginFirstFromPreviousSuggest = loginsList[0] === values.login;
    const data = {
        trackId,
        login: loginsList.includes(values.login) ? '' : values.login || '',
        firstname: values.firstname || '',
        lastname: values.lastname || ''
    };

    return new Promise((resolve) => {
        return api
            .getSuggestedLogins(data)
            .then((response = {}) => {
                const {logins = []} = response;

                dispatch(updateSuggestedLogins({logins}));

                if (useFirstLogin && logins.length && (isLoginFirstFromPreviousSuggest || !values.login)) {
                    dispatch(updateValues({field: 'login', value: logins[0]}));
                }

                resolve();
            })
            .catch(() => {
                resolve([]);
                dispatch(updateSuggestedLogins({logins: []}));
            });
    });
};

export const getLogins = () => (dispatch, getState) => getSuggestedLogins(dispatch, getState());
