import {connect} from 'react-redux';
import {LoginSuggest} from './LoginSuggest.jsx';
import {updateValues, updateErrors} from '@blocks/actions/form';
import {getFormValues} from '@blocks/selectors';

const mapStateToProps = (state = {}, {logins}) => {
    const {logins: loginsFromState = {}} = state;
    const values = getFormValues(state);
    const {firstname, lastname, login} = values;

    return {
        logins: logins || loginsFromState,
        deps: {
            firstname,
            lastname,
            login
        }
    };
};

const mapDispatchToProps = {
    updateValues,
    updateErrors
};

const ConnectedLoginSuggest = connect(mapStateToProps, mapDispatchToProps)(LoginSuggest);

export {ConnectedLoginSuggest as LoginSuggest};
