import {connect} from 'react-redux';
import {getLanguage} from '@blocks/selectors';
import {Logo} from './Logo.jsx';
import {showDebugInfo} from '@blocks/authv2/actions/nativeMobileApi';

const mapStateToProps = (state = {}, {isStatic}) => {
    const {settings = {}, common = {}, am = {}} = state;
    const {tld, authCustomsStatic} = settings;
    const {isAm = false} = am;
    const {isWebView, isAM} = common;

    return {
        isStatic: isStatic || isWebView || isAM,
        authCustomsStatic,
        lang: getLanguage(state),
        tld,
        isAm
    };
};

const mapDispatchToProps = (dispatch) => {
    return {
        onShowDebugInfo() {
            dispatch(showDebugInfo());
        }
    };
};

const ConnectedLogo = connect(mapStateToProps, mapDispatchToProps)(Logo);

export {ConnectedLogo as Logo};
