import './NoJS.styl';
import React, {Component} from 'react';
import {cn} from '@bem-react/classname';
import PropTypes from 'prop-types';
import {Link} from '@components/Link';

const b = cn('NoJS');

export class NoJS extends Component {
    shouldComponentUpdate() {
        return false;
    }

    render() {
        const {isFloat, tld = 'ru'} = this.props;
        const helpLink = `https://yandex.${
            tld === 'ua' ? 'ru' : tld
        }/support/common/browsers-settings/browsers-java-js-settings.xml`;

        return (
            <div className={b({isFloat})}>
                <div className={b('message')}>
                    <div className={b('title')}>{i18n('_AUTH_.nojs.title')}</div>
                    {i18n('_AUTH_.nojs.message.1')}
                    <Link href={helpLink} target='_blank'>
                        {' '}
                        {i18n('_AUTH_.nojs.message.2')}.
                    </Link>
                </div>
            </div>
        );
    }
}

NoJS.propTypes = {
    tld: PropTypes.string.isRequired,
    isFloat: PropTypes.bool
};
