import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import './Notification.styl';

const b = cn('Notification');

const COMPONENT_TYPES = {
    block: 'div',
    button: 'button'
};

export class Notification extends React.PureComponent {
    onClick = () => {
        const {onClick = null, closeNotification} = this.props;

        if (!onClick) {
            return;
        }

        onClick();
        closeNotification();
    };

    render() {
        const {text, iconType, type = 'block'} = this.props;
        const Component = COMPONENT_TYPES[type];

        return (
            <Component className={b({isTextAlignCenter: !iconType})} role='alert' onClick={this.onClick}>
                {iconType && <span aria-hidden='true' className={b('icon', {type: iconType})} />}
                <span className={b('text')} dangerouslySetInnerHTML={{__html: text}} />
            </Component>
        );
    }
}

Notification.propTypes = {
    type: PropTypes.oneOf(['block', 'button']),
    text: PropTypes.string,
    iconType: PropTypes.string,
    theme: PropTypes.string,
    onClick: PropTypes.function,
    closeNotification: PropTypes.func
};
