import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {getCookie} from '@blocks/utils';
import {Notification} from '@components/Notification';
import './NotificationList.styl';

const b = cn('NotificationList');
const NOTIFICATION_SHOWN_DEFAULT_TIMEOUT = 4000;

export class NotificationList extends React.PureComponent {
    componentWillUnmount() {
        clearTimeout(this.timerId);
        this.closeNotification();
    }

    componentDidUpdate(prevProps) {
        const {notifications: {isVisible} = {}, isTesting, shownTimeout} = this.props;
        const {notifications: {isVisible: prevIsVisible} = {}} = prevProps;
        const time =
            (isTesting && Number(getCookie('DEBUG_NOTIFICATION_TIME'))) ||
            shownTimeout ||
            NOTIFICATION_SHOWN_DEFAULT_TIMEOUT;

        if (!prevIsVisible && isVisible) {
            this.timerId = setTimeout(() => this.closeNotification(), time);
        }
    }

    closeNotification = () => {
        this.props.setNotificationsState({isVisible: false, notificationsList: []});
    };

    render() {
        const {notifications: {notificationsList = []} = {}, setNotificationsState} = this.props;

        if (!notificationsList.length) {
            return null;
        }

        return (
            <div className={b()}>
                {notificationsList.map((notification, i) => (
                    <div className={b('notification')} key={i}>
                        {notification && (
                            <Notification
                                setNotificationsState={setNotificationsState}
                                closeNotification={this.closeNotification}
                                {...notification}
                            />
                        )}
                    </div>
                ))}
            </div>
        );
    }
}

NotificationList.propTypes = {
    shownTimeout: PropTypes.number,
    isTesting: PropTypes.bool,
    setNotificationsState: PropTypes.func,
    notifications: PropTypes.object
};
