import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

import './PageHeaderPlus.styl';

const b = cn('PageHeaderPlus');

export class PageHeaderPlus extends React.Component {
    state = {state: null, balance: null, plusLink: null};
    componentDidMount() {
        const {getPlusBalance} = this.props;

        getPlusBalance()
            .done(({state, balance, plusLink}) => this.setState({state, balance, plusLink}))
            .fail(() => this.setState({state: 'error'}));
    }
    render() {
        const {hasPlus, language} = this.props;
        const {state, balance, plusLink} = this.state;

        if (state === 'no-exp' || !plusLink) {
            return null;
        }
        if (state === 'ok') {
            return (
                <a className={b({balance: true})} href={plusLink}>
                    <div className={b('icon')} />
                    <div className={b('balance')}>{balance}</div>
                </a>
            );
        }
        if (state === 'no-balance' || hasPlus) {
            return (
                <a className={b({text: true})} href={plusLink}>
                    <div className={b('text', {en: language !== 'ru'})} />
                </a>
            );
        }
        return null;
    }
}

PageHeaderPlus.propTypes = {
    language: PropTypes.string,
    getPlusBalance: PropTypes.func,
    hasPlus: PropTypes.bool.isRequired
};
