import {allowedAndroidYandexBonusVersion, allowedIOSYandexBonusVersion, allowedIOSVersion} from './constants';

export const ROUTES_WITH_RELOAD = ['/profile/documents'];

/**
 * Метод сравнения версий.
 * @example v1 > v2 -> 1. v1 < v2 -> -1. v1 = v2 -> 0.
 * @param {*} v1
 * @param {*} v2
 * @returns -1 | 0 | 1
 */
export const versionCompare = (v1, v2) => {
    let v1parts = v1.split('.');

    let v2parts = v2.split('.');

    function isValidPart(x) {
        return /^\d+$/.test(x);
    }

    if (!v1parts.every(isValidPart) || !v2parts.every(isValidPart)) {
        return NaN;
    }

    v1parts = v1parts.map(Number);
    v2parts = v2parts.map(Number);

    for (var i = 0; i < v1parts.length; ++i) {
        if (v2parts.length == i) {
            return 1;
        }

        if (v1parts[i] == v2parts[i]) {
            continue;
        } else if (v1parts[i] > v2parts[i]) {
            return 1;
        } else {
            return -1;
        }
    }

    if (v1parts.length != v2parts.length) {
        return -1;
    }

    return 0;
};

export const getBonusUrl = (ua = {}, routerLinkKey) => {
    if (ua && ua.BrowserName === 'YandexSearch') {
        switch (ua.OSFamily) {
            case 'iOS':
                // Если версия ios ниже необходимой, то не показываем пункт меню.
                if (versionCompare(allowedIOSVersion, ua.OSVersion) === 1) {
                    return;
                } else if (versionCompare(allowedIOSYandexBonusVersion, ua.BrowserVersion) === (-1 || 0)) {
                    return {
                        href: 'ya-search-app-open://?uri=bonuscards://cardlist?utm_source=yndxid'
                    };
                }
                break;
            case 'Android':
                if (versionCompare(allowedAndroidYandexBonusVersion, ua.BrowserVersion) === (-1 || 0)) {
                    return {
                        href: 'bonuscards://cardlist?utm_source=yndxid'
                    };
                }
                break;
        }
    }

    return {
        [routerLinkKey]: '/profile/bonus'
    };
};

export const getPasswordUrl = (ua = {}, routerLinkKey) => {
    if (ua.BrowserName === 'YandexBrowser' || ua.BrowserName === 'YandexSearch') {
        switch (ua.OSFamily) {
            case 'iOS':
                // Если версия ios ниже необходимой, то не показываем пункт меню.
                if (versionCompare(allowedIOSVersion, ua.OSVersion) === 1) {
                    return;
                }
                return {
                    href: 'ya-search-app-open://?uri=personaldata%3A%2F%2Fpasswords'
                };
            case 'Android':
                return {
                    href: 'personal-data-manager://?screen=passwords'
                };
        }
    }

    return {
        [routerLinkKey]: '/profile/passwords'
    };
};
