import './Password.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Field} from '@components/Field';
import {FIELDS_NAMES} from '@components/Field/names';

const b = cn('Password');

class Password extends React.PureComponent {
    static defaultProps = {
        type: 'password',
        name: FIELDS_NAMES.PASSWORD,
        label: i18n('_AUTH_.field_password'),
        hasToggler: true,
        options: {
            autoCorrect: 'off',
            autoCapitalize: 'off',
            autoComplete: 'new-password'
        }
    };

    ref = React.createRef();

    componentDidMount() {
        if (this.props.skipFocus) {
            return;
        }

        this.ref.current.focus();
    }

    toggleVisibility = () => {
        const {togglePasswordVisibilityState} = this.props;

        togglePasswordVisibilityState();
    };

    render() {
        const {type, view, hasErrorIcon, ...props} = this.props;
        const togglerTitle = type === 'password' ? i18n('_AUTH_.passwd.view') : i18n('_AUTH_.passwd.hide');

        return (
            <Field
                size='l'
                ref={this.ref}
                view={view || 'big-input'}
                type={type}
                hasErrorIcon={hasErrorIcon}
                iconRight={
                    <button
                        className={b('toggler', {
                            visible: type === 'text',
                            withRightShift: hasErrorIcon,
                            view
                        })}
                        tabIndex='2'
                        type='button'
                        title={togglerTitle}
                        aria-label={togglerTitle}
                        id='password-toggle'
                        onClick={this.toggleVisibility}
                    />
                }
                {...props}
            />
        );
    }
}

Password.propTypes = {
    type: PropTypes.string,
    name: PropTypes.string,
    label: PropTypes.string,
    placeholder: PropTypes.string,
    passwordWeight: PropTypes.string,
    hideLabel: PropTypes.bool,
    shouldValidate: PropTypes.bool,
    togglePasswordVisibilityState: PropTypes.func.isRequired,
    options: PropTypes.shape({
        autoCorrect: PropTypes.string,
        autoCapitalize: PropTypes.string,
        autoComplete: PropTypes.string
    }),
    hasToggler: PropTypes.bool,
    skipFocus: PropTypes.bool,
    hasErrorIcon: PropTypes.bool,
    view: PropTypes.string,
    validationTrack: PropTypes.string
};

export {Password};
