import {connect} from 'react-redux';
import {Password} from './Password.jsx';
import {togglePasswordVisibilityState} from '@blocks/actions/form';

const mapStateToProps = (state = {}) => {
    const {form = {}} = state;
    const {isPasswordVisible, passwordWeight, errors = {}, values = {}} = form;
    const {errorDescription, warning} = errors.password;

    return {
        type: isPasswordVisible ? 'text' : 'password',
        password: values.password,
        passwordWeight,
        errorDescription,
        warning
    };
};

const mapDispatchToProps = {
    togglePasswordVisibilityState
};

const ConnectedPassword = connect(mapStateToProps, mapDispatchToProps)(Password);

export {ConnectedPassword as Password};
