import React from 'react';
import PropTypes from 'prop-types';
import {Field} from '@components/Field';
import {FIELDS_NAMES} from '@components/Field/names';
import {updateErrors} from '@blocks/actions/form';
import {getError} from '@blocks/utils';

class PasswordConfirm extends React.PureComponent {
    static defaultProps = {
        type: 'password',
        name: FIELDS_NAMES.PASSWORD_CONFIRM,
        label: i18n('_AUTH_.field_label_repeat-passwd2')
    };

    componentDidUpdate() {
        const {shouldValidateOnUpdates} = this.props;

        if (shouldValidateOnUpdates) {
            this.compareWithPassword();
        }
    }

    compareWithPassword = () => {
        const {name, password, passwordConfirm, dispatch} = this.props;

        if (password !== passwordConfirm) {
            dispatch(updateErrors({field: name, error: getError([name], 'notequal')}));
        } else {
            dispatch(updateErrors({field: name, error: {code: '', text: ''}}));
        }
    };

    render() {
        const {type, name, label, shouldValidate, view, size} = this.props;

        return (
            <Field
                type={type}
                onBlur={this.compareWithPassword}
                label={label}
                name={name}
                shouldValidate={shouldValidate}
                view={view}
                size={size}
            />
        );
    }
}

PasswordConfirm.propTypes = {
    size: PropTypes.string,
    view: PropTypes.string,
    type: PropTypes.string,
    name: PropTypes.string,
    label: PropTypes.string,
    password: PropTypes.string,
    passwordConfirm: PropTypes.string,
    shouldValidate: PropTypes.bool,
    shouldValidateOnUpdates: PropTypes.bool,
    dispatch: PropTypes.func
};

export {PasswordConfirm};
