import {connect} from 'react-redux';
import {PasswordConfirm} from './PasswordConfirm.jsx';
import {FIELDS_NAMES} from '@components/Field/names';

const mapStateToProps = (state = {}) => {
    const {form = {}} = state;
    const {isPasswordVisible, values = {}} = form;

    return {
        type: isPasswordVisible ? 'text' : 'password',
        passwordConfirm: values[FIELDS_NAMES.PASSWORD_CONFIRM],
        password: values[FIELDS_NAMES.PASSWORD]
    };
};

const ConnectedPasswordConfirm = connect(mapStateToProps)(PasswordConfirm);

export {ConnectedPasswordConfirm as PasswordConfirm};
