import React from 'react';
import PropTypes from 'prop-types';
import {Field} from '@components/Field';

class Phone extends React.PureComponent {
    ref = React.createRef();

    focus = () => {
        if (this.ref.current && this.ref.current.focus) {
            this.ref.current.focus();
        }
    };

    getPrefix = () => {
        const {tld} = this.props;

        switch (tld) {
            case 'ru':
            case 'kz': {
                return '+7';
            }

            case 'by': {
                return '+375';
            }

            case 'ua': {
                return '+380';
            }

            case 'uz': {
                return '+998';
            }

            default: {
                return '';
            }
        }
    };

    componentDidMount() {
        const {useNumberPrefix, hasPhoneMask, value, name, updateValues} = this.props;

        if (!useNumberPrefix && !hasPhoneMask) {
            return;
        }

        const prefix = this.getPrefix();

        if (!value && prefix) {
            updateValues({field: name, value: prefix});
        }
    }

    render() {
        const {useNumberPrefix, hasPhoneMask, tld, hideLabel} = this.props;

        return (
            <Field
                hideLabel={hideLabel || hasPhoneMask}
                ref={this.ref}
                {...this.props}
                placeholder={useNumberPrefix ? this.getPrefix() : ''}
                hasPhoneMask={tld === 'ru' && hasPhoneMask}
            />
        );
    }
}

Phone.propTypes = {
    useNumberPrefix: PropTypes.bool.isRequired,
    value: PropTypes.string.isRequired,
    name: PropTypes.string.isRequired,
    updateValues: PropTypes.func.isRequired,
    tld: PropTypes.string.isRequired,
    hasPhoneMask: PropTypes.bool,
    hideLabel: PropTypes.bool
};

export {Phone};
