import {connect} from 'react-redux';
import {Phone} from './Phone.jsx';
import {getFormValues, hasExp} from '@blocks/selectors';
import {updateValues} from '@blocks/actions/form';

const mapStateToProps = (state = {}, {name}) => {
    const {settings = {}} = state;
    const {tld} = settings;

    return {
        tld,
        value: getFormValues(state)[name] || '',
        useNumberPrefix: hasExp(state, 'show-reg-new-phone-formatter-on')
    };
};

const mapDispatchToProps = {
    updateValues
};

const ConnectedPhone = connect(mapStateToProps, mapDispatchToProps, null, {forwardRef: true})(Phone);

export {ConnectedPhone as Phone};
