import api from '@blocks/api';
import reloadCaptcha from '@components/Captcha/actions/reloadCaptcha';

export const SHOW_REQUEST_PASSWORD = 'SHOW_REQUEST_PASSWORD';
export const SHOW_REQUEST_CAPTCHA = 'SHOW_REQUEST_CAPTCHA';
export const CHECK_HUMAN = 'CHECK_HUMAN';
export const CHECK_HUMAN_SUCCESS = 'CHECK_HUMAN_SUCCESS';
export const CHECK_HUMAN_FAIL = 'CHECK_HUMAN_FAIL';
export const VALIDATE_DOMIK_FORM = 'VALIDATE_DOMIK_FORM';
export const HIDE_DOMIK = 'HIDE_DOMIK';

export function showRequestPassword(show) {
    return {
        type: SHOW_REQUEST_PASSWORD,
        show
    };
}

export function showRequestCaptcha(show) {
    return {
        type: SHOW_REQUEST_CAPTCHA,
        show
    };
}

export function hideDomik() {
    return {
        type: HIDE_DOMIK
    };
}

export function validateForm(data) {
    return {
        type: VALIDATE_DOMIK_FORM,
        data
    };
}

export function checkHuman(data) {
    return function(dispatch, getState) {
        const state = getState();
        const common = state.common;
        const {errors} = state.domik;
        const actionForRepeat = common.actionForRepeat || {};
        const {action, payload} = actionForRepeat;

        data.csrf_token = common.csrf; // eslint-disable-line
        data.track_id = common.track_id; // eslint-disable-line

        if (Object.keys(errors).length !== 0) {
            return;
        }
        if ('captcha' in data) {
            data.key = state.captcha.key; // eslint-disable-line
            data.answer = data.captcha; // eslint-disable-line
            delete data.captcha; // eslint-disable-line

            dispatch(reloadCaptcha());
        }
        dispatch({
            type: CHECK_HUMAN
        });
        api.request('checkHuman', data)
            .done(() => {
                dispatch({
                    type: CHECK_HUMAN_SUCCESS
                });
                if (action) {
                    dispatch(action(...payload));
                }
            })
            .fail((res) => {
                dispatch({
                    type: CHECK_HUMAN_FAIL,
                    res
                });
            });
    };
}
