import {connect} from 'react-redux';
import {getLanguage, isMobile} from '@blocks/selectors';
import {RequestDataDomik} from './RequestDataDomik.jsx';

function mapStateToProps(state) {
    const {
        settings = {},
        access: {is2faEnabled}
    } = state;

    return {
        domik: state.domik,
        captcha: state.captcha,
        lang: getLanguage(state),
        is2faEnabled,
        isMobileCaptcha: Boolean(settings.ua.isMobile || settings.ua.isTablet),
        isMobile: isMobile(state)
    };
}

const RequestDataDomikConnected = connect(mapStateToProps)(RequestDataDomik);

export {RequestDataDomikConnected as RequestDataDomik};
