import {
    SHOW_REQUEST_PASSWORD,
    SHOW_REQUEST_CAPTCHA,
    HIDE_DOMIK,
    VALIDATE_DOMIK_FORM,
    CHECK_HUMAN,
    CHECK_HUMAN_SUCCESS,
    CHECK_HUMAN_FAIL
} from './actions';

export default function domik(state = {}, action) {
    switch (action.type) {
        case SHOW_REQUEST_PASSWORD:
            return Object.assign({}, state, {
                requestPassword: action.show,
                passwordNotMatched: false
            });
        case SHOW_REQUEST_CAPTCHA:
            return Object.assign({}, state, {
                requestCaptcha: action.show,
                captchaNotMatched: false
            });
        case VALIDATE_DOMIK_FORM: {
            const errors = {};
            const formData = action.data;

            for (const key in formData) {
                if (formData[key] === '') {
                    errors[key] = 'empty';
                }
            }
            return Object.assign({}, state, {
                errors
            });
        }
        case CHECK_HUMAN:
            return Object.assign({}, state, {
                loading: true
            });
        case HIDE_DOMIK:
        case CHECK_HUMAN_SUCCESS:
            return Object.assign({}, state, {
                errors: {},
                requestCaptcha: false,
                requestPassword: false,
                loading: false
            });
        case CHECK_HUMAN_FAIL: {
            const captchaNotMatched = action.res.errors.find((err) => err === 'captcha.not_matched');
            const passwordNotMatched = action.res.errors.find((err) => err === 'password.not_matched');
            const errors = {};

            if (captchaNotMatched) {
                errors.captcha = 'notMatched';
            }
            if (passwordNotMatched) {
                errors.password = 'notMatched';
            }

            return Object.assign({}, state, {
                errors,
                loading: false
            });
        }
        default:
            return state;
    }
}
