import React from 'react';
import PropTypes from 'prop-types';
import {Link} from 'react-router-dom';

import './ReturnToService.styl';

export default class ReturnToService extends React.Component {
    constructor(props) {
        super(props);

        this.onReturn = this.onReturn.bind(this);
    }

    onReturn(event) {
        if (this.props.onReturn) {
            event.preventDefault();
            this.props.onReturn();
        }
    }

    render() {
        const {retpath, pathTo, className, useHref} = this.props;
        const cls = className || 'p-return__default';

        return (
            <div className={cls}>
                {retpath || useHref ? (
                    <a
                        href={useHref ? pathTo : retpath}
                        className='p-return'
                        onClick={this.onReturn}
                        aria-label={i18n('_AUTH_.common.back')}
                    />
                ) : (
                    <Link
                        to={pathTo}
                        className='p-return'
                        onClick={this.onReturn}
                        aria-label={i18n('_AUTH_.common.back')}
                    />
                )}
            </div>
        );
    }
}

ReturnToService.propTypes = {
    onReturn: PropTypes.func,
    className: PropTypes.string,
    retpath: PropTypes.string,
    pathTo: PropTypes.string.isRequired,
    useHref: PropTypes.bool
};
