import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Field} from '@components/Field';
import {SecurityQuestionSelector} from '@components/SecurityQuestionSelector';
import './SecurityQuestionSecurityAnswer.styl';

const b = cn('SecurityQuestionSecurityAnswer');

export class SecurityQuestionSecurityAnswer extends React.PureComponent {
    static propTypes = {
        className: PropTypes.string,
        onInputChange: PropTypes.func.isRequired,
        selectedCustomQuestion: PropTypes.bool,
        hintAnswer: PropTypes.string,
        hintAnswerError: PropTypes.string,
        hintAnswerState: PropTypes.string,
        hintQuestionCustom: PropTypes.string,
        hintQuestionCustomState: PropTypes.string,
        hintQuestionCustomError: PropTypes.string,
        errors: PropTypes.object
    };

    _onHintQuestionCustomChange = (value) => {
        this.props.onInputChange({
            field: 'hint_question_custom',
            value
        });
    };

    _onHintAnswerChange = (value) => {
        this.props.onInputChange({
            field: 'hint_answer',
            value
        });
    };

    render() {
        const {
            className,
            hintAnswer,
            hintAnswerError,
            hintAnswerState,
            hintQuestionCustom,
            hintQuestionCustomError,
            hintQuestionCustomState,
            selectedCustomQuestion
        } = this.props;

        return (
            <div className={b('', [className])}>
                <SecurityQuestionSelector className={b('questionSelector')} />
                {selectedCustomQuestion && (
                    <Field
                        size='l'
                        label={i18n('_AUTH_.question_enter_custom')}
                        value={hintQuestionCustom}
                        name='hint_question_custom'
                        type='text'
                        error={hintQuestionCustomError}
                        onChange={this._onHintQuestionCustomChange}
                        view='big-input'
                        isValid={hintQuestionCustomState === 'valid'}
                    />
                )}
                <Field
                    size='l'
                    label={i18n('_AUTH_.field_hint_answer')}
                    value={hintAnswer}
                    name='hint_answer'
                    type='text'
                    error={hintAnswerError}
                    onChange={this._onHintAnswerChange}
                    view='big-input'
                    isValid={hintAnswerState === 'valid'}
                />
            </div>
        );
    }
}
