import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Select} from '@components/Select';

const b = cn('SecurityQuestionSelector');

export class SecurityQuestionSelector extends React.PureComponent {
    static propTypes = {
        hintQuestionId: PropTypes.string.isRequired,
        questionsList: PropTypes.array.isRequired,
        onSelectChange: PropTypes.func.isRequired,
        className: PropTypes.string
    };

    render() {
        const {className, onSelectChange, questionsList, hintQuestionId} = this.props;

        return (
            <div className={b('', [className])}>
                <Select
                    name='hint_question_id'
                    id='hintQuestionId'
                    dataT='hintQuestionId'
                    size='l'
                    onChange={onSelectChange}
                    options={questionsList.map((question) => ({value: question.val, content: question.text}))}
                    width='max'
                    value={hintQuestionId}
                />
            </div>
        );
    }
}
