import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Checkbox} from '@components/Checkbox';
import {cn} from '@bem-react/classname';

import './PermissionCheckbox.styl';

const b = cn('PermissionCheckbox');

export class ServiceSubscriptionPermission extends Component {
    handleToggle = () => {
        const {keepUnsubscribedValue, toggleServiceSubscriptionPermission} = this.props;

        toggleServiceSubscriptionPermission(!keepUnsubscribedValue);
    };

    render() {
        const {isShown, keepUnsubscribedValue, isWhiteLabel = false} = this.props;

        if (isShown) {
            return (
                <div className={b()}>
                    <span className={b('checkbox')}>
                        <Checkbox
                            size='m'
                            id='keep_unsubscribed'
                            name='keep_unsubscribed'
                            checked={keepUnsubscribedValue}
                            onChange={this.handleToggle}
                        />
                    </span>
                    <label className={b('label')} htmlFor='keep_unsubscribed'>
                        {isWhiteLabel
                            ? i18n('_AUTH_.registration.service_subscr_permission.whitelabel')
                            : i18n('_AUTH_.registration.service_subscr_permission')}
                    </label>
                </div>
            );
        }
        return null;
    }
}

ServiceSubscriptionPermission.propTypes = {
    keepUnsubscribedValue: PropTypes.bool,
    isShown: PropTypes.bool,
    isWhiteLabel: PropTypes.bool,
    toggleServiceSubscriptionPermission: PropTypes.func
};
